;---------------------------------------------------------------------------
; Format:
; [Statedef STATENO]
; type = ?      S/C/A/L  stand/crouch/air/liedown
; movetype = ?  I/A/H    idle/attack/gethit
; physics = ?   S/C/A/N  stand/crouch/air/none
; juggle = ?             air juggle points move requires
;
; [State STATENO, ?]     ? - any number you choose
; type = ?
; ..
; Jump Land
[Statedef 52]
type    = S
physics = S
ctrl = 0
anim = 47

[State 52, 1]
type = VelSet
trigger1 = Time = 0
y = 0

[State 52, 2]
type = PosSet
trigger1 = Time = 0
y = 0

[State 52, 3]
type = CtrlSet
trigger1 = Time = 3
value = 1

[State 52, 4]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

[Statedef 180]
type = S
movetype = I
physics = S
sprpriority = 2
velset = 0,0
ctrl = 0
anim = 181

[State 180, 2]
type = PlaySnd
trigger1 = animelem = 1
value = 1, 7

[State 180, 2]
type = PlaySnd
trigger1 = animelem = 2
value = 1, 5

[State 181, 5]
type = AssertSpecial
trigger1 = time < 360
flag = RoundNotOver


; PREINTRO
[Statedef 190]
type = S
ctrl = 0
velset = 0,0

[State 190, 1]
type = ChangeAnim
trigger1 = SelfAnimExist(190)
value = 0

[State 190, 2] ;Go straight to intro.
type = ChangeState
trigger1 = Time = 0
value = 191

; INTRO 
[Statedef 191]
type = S
ctrl = 0
anim = 191

[State 191, 1]
type = VarSet
trigger1 = Time >= 0
v = 0
value = Life

[State 0, 5]
type = Helper
triggerall = numHelper(2000) <= 0
trigger1 = RoundState = 2 
ID = 2000
name = "Sister"
pos = 20, 0
postype = Back
stateno = 2191
helpertype = normal
keyctrl = 0
ownpal = 1

[State 0, 5]
type = Helper
triggerall = numHelper(4000) <= 0
trigger1 = RoundState = 2
ID = 4000
name = "Avdol"
pos = 0, 0
postype = Front
stateno = 4191
helpertype = normal
keyctrl = 0
ownpal = 1

[State 191, 2] ;Assert this until you want "round 1, fight" to begin
type = AssertSpecial
trigger1 = Time = [0,70]
flag = Intro

[State 191, 1]
type = PlaySnd
trigger1 = AnimElem = 1
value = 100, 1

[State 191, 1]
type = PlaySnd
trigger1 = AnimElem = 2
value = 1, 7

[State 191, 1]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 0

;Standing Fierce
[Statedef 205]
type = S
movetype = A
physics = S
juggle = 2
poweradd = 20
ctrl = 0
anim = 205
velset = 0, 0

[State 220, 1]
type = PlaySnd
trigger1 = AnimElem = 2
value = 0, 0

[State 220, 1]
type = hitdef
trigger1 = time = 0
attr = S,NA
damage = 35, 5
animtype = Light
guardflag = MA
pausetime = 5,5
guardflag = MA
sparkxy = -10,-95
hitsound = S1,0
guardsound = S6,0
ground.type = High
ground.slidetime = 10
ground.hittime = 11
ground.velocity = -8.5
air.velocity = 0

[state 220, 3]
type = Changestate
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;Standing Fierce
[Statedef 215]
type = S
movetype = A
physics = N
juggle = 2
poweradd = 70
ctrl = 0
velset = 2.5, 0
anim = 215

[State 220, 1]
type = PlaySnd
trigger1 = AnimElem = 2
trigger2 = AnimElem = 5
value = 0, 0

[State 220, 1]
type = PlaySnd
trigger1 = AnimElem = 10
value = 0, 1

[State 220, 1]
type = hitdef
trigger1 = AnimElem = 2
trigger2 = AnimElem = 5
attr = S,NA
damage = 35,5
animtype = Light
guardflag = MA
pausetime = 11,11
guardflag = MA
sparkxy = -10,-95
hitsound = S1,0
guardsound = S6,0
ground.type = High
ground.slidetime = 12
ground.hittime = 20
ground.velocity = -8.5
air.velocity = 0

[State 220, 1]
type = hitdef
trigger1 = AnimElem = 10
attr = S,NA
damage = 45,5
animtype = Hard
guardflag = MA
pausetime = 11,11
guardflag = MA
sparkxy = -10,-75
hitsound = S1,2
guardsound = S6,0
ground.type = Low
ground.slidetime = 16
ground.hittime = 25
ground.velocity = -8.5
air.velocity = 0
fall = 1

[state 220, 3]
type = Changestate
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;Standing Fierce
[Statedef 210]
type = S
movetype = A
physics = S
juggle = 2
poweradd = 40
ctrl = 0
anim = 210
velset = 0, 0

[State 220, 1]
type = PlaySnd
trigger1 = AnimElem = 3
value = 1, 15

[State 220, 1]
type = hitdef
trigger1 = time = 0
attr = S,NA
damage = 45, 6
animtype = Hard
guardflag = MA
pausetime = 11,11
guardflag = MA
sparkxy = -10,-75
hitsound = S1,14
guardsound = S6,0
ground.type = Low
ground.slidetime = 16
ground.hittime = 25
ground.velocity = -8.5
air.velocity = 0

[state 220, 3]
type = Changestate
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;Standing Fierce
[Statedef 240]
type = S
movetype = A
physics = N
juggle = 2
poweradd = 60
ctrl = 0
anim = 240
velset = 4, 0

[State 220, 1]
type = Velset
trigger1 = AnimElem = 3
x = 0

[State 220, 1]
type = PlaySnd
trigger1 = AnimElem = 3
value = 0, 1

[State 220, 1]
type = hitdef
trigger1 = time = 0
attr = S,NA
damage = 55,7
animtype = Hard
guardflag = MA
pausetime = 11,11
guardflag = MA
sparkxy = -10,-75
hitsound = S1,2
guardsound = S6,0
ground.type = High
ground.slidetime = 16
ground.hittime = 25
ground.velocity = -8.5
air.velocity = 0

[state 220, 3]
type = Changestate
trigger1 = AnimTime = 0
value = 0
ctrl = 1

[Statedef 216]
type = S
movetype = A
physics = S
juggle = 2
poweradd = 70
ctrl = 0
anim = 216
velset = 0, 0

[state 220, 3]
type = Changestate
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;Special
[Statedef 1001]
type = S
movetype = A
physics = N
juggle = 2
ctrl = 0
anim = 21
velset = 0, 0

[State 220, 1]
type = PlayerPush
trigger1 = time >=0
value = 0 

[State 220,1]
type = StateTypeSet
trigger1 = AnimElem = 1
statetype = S

[State 220, ]
type = VelSet
trigger1 = AnimElem = 1
x = -6
y = -3.5

[State 220, ]
type = VelSet
trigger1 = pos y <= -100
y = 0

[State 220]
type = changestate
trigger1 = backedgebodydist < 20 && pos y <= -90
value = 1002

;Special
[Statedef 1002]
type = S
movetype = A
physics = N
juggle = 2
poweradd = 70
ctrl = 0
anim = 9104
velset = 0, 0


[State Super BG]
type = Helper
trigger1 = AnimElem = 1
helpertype = normal
id = 9006
pos = 0,0
postype = p1;back
stateno = 9006
keyctrl = 0
ignorehitpause = 1
pausemovetime = 999999
supermovetime = 999999

[State 1002, Superpause]
type = Playsnd
trigger1 = AnimElem = 1
value = 11, 21

[State 1002, Superpause]
type = Playsnd
trigger1 = AnimElem = 1
value = 1, 5

[State 1002, Superpause]
type = Playsnd
trigger1 = AnimElem = 2
value = 100, 0

[State 1002, riches]
type = Helper
trigger1 = AnimElem = 4, = 0
stateno = 1004
postype = p1
pos = 0,-125
name = "Treasures"
id = 1004
ownpal = 1

[State 1002, riches]
type = Helper
trigger1 = AnimElem =3, = 1
stateno = 1006
postype = p1
pos = 204,-130
name = "Treasures"
id = 1006
ownpal = 1

[State 1002, riches]
type = Helper
trigger1 = AnimElem = 4, = 0
stateno = 1005
postype = p1
pos = 190,-134
name = "Treasures"
id = 1005
ownpal = 1

[State 1002, riches]
type = Helper
trigger1 = AnimElem =3, = 1
stateno = 1007
postype = p1
pos = 94,-139
name = "Treasures"
id = 1007
ownpal = 1

[State 1002, riches]
type = Helper
trigger1 = AnimElem =4, = 0
stateno = 1005
postype = p1
pos = 23,-125
name = "Treasures"
id = 1005
ownpal = 1

[State 1002, riches]
type = Helper
trigger1 = AnimElem = 3, = 1
stateno = 1004
postype = p1
pos = 57,-127
name = "Treasures"
id = 1004
ownpal = 1

[State 1002, riches]
type = Helper
trigger1 = AnimElem = 4, = 0
stateno = 1004
postype = p1
pos = -57,-129
name = "Treasures"
id = 1004
ownpal = 1

[State 1002, riches]
type = Helper
trigger1 = AnimElem = 3, = 1
stateno = 1006
postype = p1
pos = -38,-131
name = "Treasures"
id = 1004
ownpal = 1

[State 1002, riches]
type = Helper
trigger1 = AnimElem = 4, = 0
stateno = 1004
postype = p1
pos = -58,-134
name = "Treasures"
id = 1004
ownpal = 1

[State 1002, riches]
type = Helper
trigger1 = AnimElem = 4, = 0
stateno = 1007
postype = p1
pos = -48,-124
name = "Treasures"
id = 1004
ownpal = 1

[State 1002, riches]
type = Helper
trigger1 = AnimElem = 4, = 0
stateno = 1006
postype = p1
pos = -8,-127
name = "Treasures"
id = 1004
ownpal = 1

[State 1002, riches]
type = Helper
trigger1 = AnimElem = 3, = 1
stateno = 1005
postype = p1
pos = -8,-131
name = "Treasures"
id = 1004
ownpal = 1

[State 1002, riches]
type = Helper
trigger1 = AnimElem = 4, = 0
stateno = 1006
postype = p1
pos = 63,-133
name = "Treasures"
id = 1006
ownpal = 1

[State 1002, riches]
type = Helper
trigger1 = AnimElem = 3, = 1
stateno = 1006
postype = p1
pos = 106,-124
name = "Treasures"
id = 1006
ownpal = 1

[State 1002, riches]
type = Helper
trigger1 = AnimElem  = 4, = 0
stateno = 1007
postype = p1
pos = 43,-127
name = "Treasures"
id = 1005
ownpal = 1

[State 1002, riches]
type = Helper
trigger1 = AnimElem  = 3, = 1
stateno = 1005
postype = p1
pos = 78,-121
name = "Treasures"
id = 1005
ownpal = 1

[State 220]
type = changestate
trigger1 = time = 125
value = 1003

; Treasures
[Statedef 1004]
type = S
movetype = A
physics = N
anim = 9102
sprpriority = 2
ctrl = 0
velset = 7, 5

[State 1004, 1]
type = hitdef
trigger1 = time = 0
attr = S,NA
damage = 3,1
animtype = Hard
poweradd = 0, 0 
pausetime = 0,11
guardflag = MA
sparkxy = 0,0
hitsound = S1,14
guardsound = S6,0
ground.type = Low
ground.slidetime = 16
ground.hittime = 25
ground.velocity = -3.5,-7
air.velocity = -2,-3
fall = 1

[State 1004,2]
type = Angleadd
trigger1 = time > 0
value = 40

[State 1004, 3]
type = AngleDraw
trigger1 = 1

[State 1004, 4]
type = AssertSpecial
trigger1 = 1
flag = NoShadow

[State 1004, 5]
type = DestroySelf
trigger1 = movecontact = 1 && time >=80

[State 1004,2]
type = Angleadd
triggerall = movecontact = 1
trigger1 = time > 0
value = -40

[State 1004,2]
type = velset
triggerall = movecontact = 1
trigger1 = time > 0
x = -3
y = -.5

[State 1004,2]
type = changeanim
trigger1 = movecontact = 1
value = 9106

[State 1004, 5]
type = DestroySelf
trigger1 = Time >= 40

; Treasures
[Statedef 1005]
type = S
movetype = A
physics = N
anim = 9100
sprpriority = 2
ctrl = 0
velset = 6, 8

[State 1005, 1]
type = hitdef
trigger1 = time = 0
attr = S,NA
damage = 3,1
poweradd = 0, 0 
animtype = Hard
pausetime = 0,11
guardflag = MA
sparkxy = 0,0
hitsound = S1,14
guardsound = S6,0
ground.type = Low
ground.slidetime = 16
ground.hittime = 25
ground.velocity = -3.5,-7
air.velocity = -2,-3
fall = 1

[State 1005, 2]
type = Angleadd
trigger1 = time > 0
value = -60

[State 1005, 3]
type = AngleDraw
trigger1 = 1

[State 1005, 4]
type = AssertSpecial
trigger1 = 1
flag = NoShadow

[State 1004, 5]
type = DestroySelf
trigger1 = movecontact = 1 && time >=80

[State 1004,2]
type = Angleadd
triggerall = movecontact = 1
trigger1 = time > 0
value = 10

[State 1004,2]
type = velset
triggerall = movecontact = 1
trigger1 = time > 0
x = 1
y = -1

[State 1004,2]
type = changeanim
trigger1 = movecontact = 1
value = 9106

[State 1004, 5]
type = DestroySelf
trigger1 = Time >= 40

; Treasures
[Statedef 1006]
type = S
movetype = A
physics = N
anim = 9101
sprpriority = 2
ctrl = 0
velset = 2, 7

[State 1006, 1]
type = hitdef
trigger1 = time = 0
attr = S,NA
damage = 3,1
poweradd = 0, 0 
animtype = Hard
pausetime = 0,11
guardflag = MA
sparkxy = 0,0
hitsound = S1,14
guardsound = S6,0
ground.type = Low
ground.slidetime = 16
ground.hittime = 25
ground.velocity = -3.5,-7
air.velocity = -2,-3
fall = 1

[State 1004, 5]
type = DestroySelf
trigger1 = movecontact = 1 && time >=80

[State 1004,2]
type = Angleadd
triggerall = movecontact = 1
trigger1 = time > 0
value = -60

[State 1004,2]
type = velset
triggerall = movecontact = 1
trigger1 = time > 0
x = -1
y = -.5

[State 1004, 5]
type = DestroySelf
trigger1 = Time >= 40

[State 1004,2]
type = changeanim
trigger1 = movecontact = 1
value = 9106

[State 1006, 3]
type = Angleadd
trigger1 = time > 0
value = 20

[State 1006, 4]
type = AngleDraw
trigger1 = 1

[State 1006, 5]
type = AssertSpecial
trigger1 = 1
flag = NoShadow


; Treasures
[Statedef 1007]
type = S
movetype = A
physics = N
anim = 9103
sprpriority = 2
ctrl = 0
velset = 6, 6

[State 1007, 1]
type = hitdef
trigger1 = time = 0
attr = S,NA
damage = 3,1
animtype = Hard
poweradd = 0, 0 
pausetime = 0,11
guardflag = MA
sparkxy = 0,0
hitsound = S1,14
guardsound = S6,0
ground.type = Low
ground.slidetime = 16
ground.hittime = 25
ground.velocity = -3.5,-7
air.velocity = -2,-3
fall = 1

[State 1007, 2]
type = Angleadd
trigger1 = time > 0
value = -50

[State 1007, 3]
type = AngleDraw
trigger1 = 1

[State 1007, 4]
type = AssertSpecial
trigger1 = 1
flag = NoShadow

[State 1004, 5]
type = DestroySelf
trigger1 = movecontact = 1 && time >=80

[State 1004,2]
type = Angleadd
triggerall = movecontact = 1
trigger1 = time > 0
value = -10

[State 1004,2]
type = changeanim
trigger1 = movecontact = 1
value = 9106

[State 1004,2]
type = velset
triggerall = movecontact = 1
trigger1 = time > 0
x = 2
y = -.5

[State 1006, 1]
type = DestroySelf
trigger1 = Time >= 40

;Special
[Statedef 1003]
type = S
movetype = A
physics = N
juggle = 2
ctrl = 0
anim = 9105
velset = 0, 0

[State 220]
type = changestate
trigger1 = Animtime = 0
value = 0
ctrl = 1

;Special
[Statedef 225]
type = S
movetype = A
physics = N
juggle = 2
poweradd = 70
ctrl = 0
anim = 21
velset = 0, 0

[State 220, 1]
type = PlayerPush
trigger1 = time >=0
value = 0 

[State 220,1]
type = StateTypeSet
trigger1 = AnimElem = 1
statetype = S

[State 220, ]
type = VelSet
trigger1 = AnimElem = 1
x = -6

[State 220]
type = changestate
trigger1 = backedgebodydist < 1 
value = 221

;Special
[Statedef 226]
type = S
movetype = A
physics = N
juggle = 2
poweradd = 70
ctrl = 0
anim = 21
velset = 0, 0

[State 220, 1]
type = PlayerPush
trigger1 = time >=0
value = 0 

[State 220,1]
type = StateTypeSet
trigger1 = AnimElem = 1
statetype = S

[State 220, ]
type = VelSet
trigger1 = AnimElem = 1
x = -6
y = 3.5

[State 220, ]
type = VelSet
trigger1 = pos y >= 45
y = 0

[State 220]
type = changestate
trigger1 = backedgebodydist < 1 && pos y >= 45
value = 227

;Special
[Statedef 227]
type = S
movetype = A
physics = N
juggle = 2
ctrl = 0
;posset = -50
anim = 220
velset = 0, 0

[State 221]
type = changestate
trigger1 = Animtime = 0
value = 228

;Standing Fierce
[Statedef 228]
type = S
movetype = A
physics = N
juggle = 2
ctrl = 0
anim = 222
velset = 8, 0

[State 220, 1]
type = PlayerPush
trigger1 = time >=0
value = 0 

[State 220, 1]
type = PlaySnd
trigger1 = AnimElem = 1
value = 100, 0

[State 220, 1]
type = hitdef
trigger1 = time = 0
attr = S,NA
damage = 125
animtype = Hard
pausetime = 11,11
;guardflag = MA
sparkxy = -10,-55
hitsound = S1,3
guardsound = S6,0
ground.type = Low
ground.slidetime = 16
ground.hittime = 25
ground.velocity = -3.5,-7
air.velocity = -4
fall = 1

[state 220, 3]
type = Changestate
trigger1 = time = 80
value = 229

;Standing Fierce
[Statedef 229]
type = S
movetype = A
physics = N
juggle = 2
ctrl = 0
anim = 223
velset = 0, 0

[State 220, ]
type = VelSet
trigger1 = AnimElem = 1
y = -3.5

[State 220, ]
type = VelSet
trigger1 = pos y <= 0
y = 0

[state 220, 3]
type = Changestate
trigger1 = AnimTime = 0 && pos y <= 0
value = 0
ctrl = 1

;Special
[Statedef 220]
type = S
movetype = A
physics = N
juggle = 2
poweradd = 70
ctrl = 0
anim = 21
velset = 0, 0

[State 220, 1]
type = PlayerPush
trigger1 = time >=0
value = 0 

[State 220,1]
type = StateTypeSet
trigger1 = AnimElem = 1
statetype = S

[State 220, ]
type = VelSet
trigger1 = AnimElem = 1
x = -6
y = 3.5

[State 220, ]
type = VelSet
trigger1 = pos y >= 0
y = 0

[State 220]
type = changestate
trigger1 = backedgebodydist < 1 && pos y >= 0
value = 221

;Special
[Statedef 221]
type = S
movetype = A
physics = N
juggle = 2
ctrl = 0
;posset = -50
anim = 220
velset = 0, 0

[State 221]
type = changestate
trigger1 = Animtime = 0
value = 222

;Standing Fierce
[Statedef 222]
type = S
movetype = A
physics = N
juggle = 2
ctrl = 0
anim = 222
velset = 8, 0

[State 220, 1]
type = PlayerPush
trigger1 = time >=0
value = 0 

[State 220, 1]
type = PlaySnd
trigger1 = AnimElem = 1
value = 100, 0

[State 220, 1]
type = hitdef
trigger1 = time = 0
attr = S,NA
damage = 125
animtype = Hard
pausetime = 11,11
;guardflag = MA
sparkxy = -10,-55
hitsound = S1,3
guardsound = S6,0
ground.type = Low
ground.slidetime = 16
ground.hittime = 25
ground.velocity = -3.5,-7
air.velocity = -4
fall = 1

[state 220, 3]
type = Changestate
trigger1 = time = 80
value = 223

;Standing Fierce
[Statedef 223]
type = S
movetype = A
physics = N
juggle = 2
ctrl = 0
anim = 223
velset = 0, 0

[state 220, 3]
type = Changestate
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Override common states (use same number to override) :
;---------------------------------------------------------------------------

[Statedef 1000]
type = S
movetype = I
physics = N
ctrl = 0
anim = 1000
velset = 0,0 ; Value to go up
sprpriority = -2

[State 1000, 1]
type = HitBy
trigger1 = 1
value = SCA, NT,ST,HT

[State 1000, 1]
type = Velset
trigger1 = AnimElem = 5 
x = 5

[State 1000, 1]
type = Velset
trigger1 = AnimElem = 6
x = 0

[State 1000, 2]
type = AfterImage
trigger1 = animelem = 1
time = 50
length = 3
TimeGap = 7
FrameGap = 1
PalBright = 0,0,0
palpostbright = 0,0,0
PalContrast = 255,255,255
PalAdd = 0,0,0
PalMul = 1,1,1

[State 1000, 3]
type = PlayerPush
trigger1 = 1
value = 0

[State 217, 1]
type = Changestate
trigger1 = Animtime = 0 
value = 0
ctrl = 1

;tele
[Statedef 217]
type = S
movetype = I
physics = N
ctrl = 0
anim = 217
velset = 0,0 ; Value to go up

[State 191, 1]
type = PlaySnd
trigger1 = AnimElem = 1
value = 1, 7

[State 217, 1]
type = Changestate
trigger1 = Animtime = 0 
value = 218

;tele
[Statedef 218]
type = S
movetype = I
physics = N
ctrl = 0
anim = 218
velset = 0,0 ; Value to go up

[State 2001, 1]
type = turn
trigger1 = P2Dist X < 0

[State 191, 1]
type = PlaySnd
trigger1 = AnimElem = 2
value = 1, 7

[State 218, 1]
type = velset
trigger1 = AnimElem = 1 
x = 12

[State 218, 1]
type = velset
trigger1 = AnimElem = 2 
x = 0

[State 218, 2]
type = Changestate
trigger1 = Animtime = 0 
value = 0

;tele
[Statedef 219]
type = S
movetype = I
physics = N
ctrl = 0
anim = 217
velset = 0,0 ; Value to go up

[State 191, 1]
type = PlaySnd
trigger1 = AnimElem = 1
value = 1, 7

[State 217, 1]
type = Changestate
trigger1 = Animtime = 0 
value = 230

;tele
[Statedef 230]
type = S
movetype = I
physics = N
ctrl = 0
anim = 218
velset = 0,0 ; Value to go up

[State 2001, 1]
type = turn
trigger1 = P2Dist X < 0

[State 191, 1]
type = PlaySnd
trigger1 = AnimElem = 2
value = 1, 7

[State 218, 1]
type = velset
trigger1 = AnimElem = 1 
x = -12

[State 218, 1]
type = velset
trigger1 = AnimElem = 2 
x = 0

[State 218, 2]
type = Changestate
trigger1 = Animtime = 0 
value = 0

;Begin Flight
[Statedef 40]
type = A
movetype = I
physics = A
ctrl = 0
anim = 20
velset = 0,-1 ; Value to go up

[State 9000, Fly]
type = ChangeState
trigger1 = Time = 1
value = 0 ; Next state
ctrl = 1

;Begin Flight
[Statedef 10]
type = A
movetype = I
physics = A
ctrl = 0
anim = 20
velset = 0,1 ; Value to go up
ctrl = 1

[State 9000, Fly]
type = ChangeState
trigger1 = AnimTime = 0
value = 0 
ctrl = 1

;taunt
[Statedef 224]
type = S
movetype = I
physics = N
velset = 0,0
ctrl = 0
anim = Ifelse(facing=1,221,224)

[State 224, 1]
type = PlaySnd
trigger1 = AnimElem = 4
value = 1, 5

[State 224, 1]
type = ChangeState
trigger1 = AnimTime = 0
value = 0 
ctrl = 1

;---------------------------------------------------------------------------
;Flight
[Statedef 0]
type = S
movetype = I
physics = N
velset = 0,0
ctrl = 0
anim = 0

;Creates a guarding ability. 
[State 9001, Guard]
type = ChangeState
triggerall = P2MoveType = A
triggerall = P2BodyDist X <= 120
trigger1 = command = "holdback"
value = 130

[State 9001,tele]
type = ChangeState
trigger1 = command = "DP_x"
value = 217

[State 9001,tele]
type = ChangeState
triggerall = power >= 1000
trigger1 = command = "QCF_xy"
value = 1001

[State 9001,tele]
type = ChangeState
trigger1 = command = "BDP_x"
value = 219

[State 9001,punch2]
type = ChangeState
trigger1 = command = "QCB_y"
value = 220

[State 9001,punch2]
type = ChangeState
trigger1 = command = "QCB_x"
value = 226

[State 9001,punch2]
type = ChangeState
trigger1 = command = "QCB_z"
value = 225

[State 9001,punch2]
type = ChangeState
trigger1 = command = "QCF_x"
value = 215

;When no directional keys are pressed, the character stays in place.
[State 9001, Stop1]
type = VelSet
trigger1 = command != "holdfwd"
trigger1 = command != "holdback"
trigger1 = command != "holdup"
trigger1 = command != "holddown"
trigger1 = Var(1) = 0
trigger2 = Pos Y < -200 
x = 0
y = 0

;Animation of character when no directional keys are pressed. 
[State 9001, Stop2]
type = ChangeAnim
trigger1 = command != "holdup"
trigger1 = command != "holddown"
trigger1 = Anim != 0 ; Flight animation (neutral)
value = 0 ; Flight animation (neutral)

;Sets Var(1) to a value of 1, when the value is currently 2.
[State 9001, VarSet1]
type = VarSet
trigger1 = command != "holdfwd"
trigger1 = command != "holdback"
trigger1 = command != "holdup"
trigger1 = command != "holddown"
trigger1 = Var(1) != 2
trigger2 = Var(1) = 2
trigger2 = Vel Y >= 2.4
v = 1
value = 1

;Sets var(1) to a value of 2, when the value is currently 1.
[State 9001, VarSet2]
type = VarSet
triggerall = Var(1) = 1
trigger1 = Vel Y <= -2.4
trigger2 = P2BodyDist Y > 400
trigger2 = Vel Y < 0
v = 1
value = 2

;When Var(1) has a value of 1, the character will float up.
[State 9001, VelAdd1]
type = VelAdd
trigger1 = Var(1) = 1
y = 0

;When Var(1) has a value of 2, the character will float down.
[State 9001, VelAdd2]
type = VelAdd
trigger1 = Var(1) = 2
y = 0

;When any directional keys are pressed, the float effect stops.
[State 9001, VelSetY]
type = VelSet
triggerall = Var(1) != 0
trigger1 = command = "holdfwd"
trigger2 = command = "holdback"
trigger3 = command = "holdup"
trigger4 = command = "holddown"
y = 0

;When any directional keys are pressed, variables will be inactive.
[State 9001, VarSetEnd]
type = VarSet
trigger1 = command = "holdfwd"
trigger2 = command = "holdback"
trigger3 = command = "holdup"
trigger4 = command = "holddown"
v = 1
value = 0

;Border to fly.
[State 9001, UpBorder1]
type = PosSet
trigger1 = Pos Y < -130
y = -130

;etc...
[State 9001, UpBorder2a]
type = PosAdd
trigger1 = P2BodyDist Y > 131
trigger1 = Vel Y < 0
y = 1

;etc...
[State 9001, UpBorder2b]
type = VelSet
trigger1 = P2BodyDist Y > 130
trigger1 = Vel Y < 0
y = 0

;etc...
[State 9001,GoDown2]
type = VelSet
trigger1 = command = "holddown"
;trigger1 = Vel Y < 0 
y = 4

[State 9001,punch]
type = ChangeState
trigger1 = command = "start"
value = 224

[State 9001,punch]
type = ChangeState
trigger1 = command = "xy"
value = 1000

;etc...
[State 9001,punch]
type = ChangeState
trigger1 = command = "a"
value = 216

[State 9001,punch]
type = ChangeState
trigger1 = command = "x"
value = 205

[State 9001,punch2]
type = ChangeState
trigger1 = command = "y"
value = 210

[State 9001,punch2]
type = ChangeState
trigger1 = command = "z"
value = 240

[State 9001,punch2]
type = ChangeState
triggerall = Helper(2000),stateno=3012
trigger1 = command = "b"
value = 2000

[State 9001,punch2]
type = ChangeState
triggerall = Helper(4000),stateno=4016
trigger1 = command = "c"
value = 4000

;etc...
[State 9001,GoUp2]
type = VelSet
trigger1 = command = "holdup"
;trigger1 = Vel Y > 0 
y = -4

;Animation of flying up.
[State 9001, GoUpAnim]
type = ChangeAnim
trigger1 = Anim != 20 ; Fly up animation
trigger1 = command = "holdup"
trigger2 = Anim != 20 ; Fly up animation
trigger2 = command = "holddown"
value = 20 ; Fly up animation

;etc...
[State 9001,GoBack2]
type = VelSet
trigger1 = command = "holdback"
x = -4.4

;Animation of flying backwards.
[State 9001, GoBackAnim]
type = ChangeAnim
trigger1 = Anim != 21 ; Fly back animation
trigger1 = command = "holdback"
value = 21

;etc...
[State 9001,GoFwd2]
type = VelSet
trigger1 = command = "holdfwd" 
x = 4

;Animation of flying forward.
[State 9001, GoFwdAnim]
type = ChangeAnim
trigger1 = Anim != 20 ; Fly forward animation
trigger1 = command = "holdfwd"
value = 20

;Character will turn around if the opponent is behind him/her.
[State 9001, Turn]
type = Turn
trigger1 = P2Dist X < 0

;Lands on the ground if character touches the ground.
[State 9001, Land1]
type = ChangeState
trigger1 = Pos Y >= 0
value = 52
ctrl = 1

;Ends the flying action if the round is over.
[State 9001, RoundEnd]
type = ChangeState
trigger1 = Win
trigger2 = Lose
value = 50

; STAND GUARD (guarding)
[Statedef 130]
type    = S
physics = S
velset = 0,0

[State 130, 1]
type = ChangeAnim
trigger1 = Anim != 130
value = 130

[State 130, Hi to Lo]
type = ChangeState
trigger1 = command = "holddown"
value = 131

[State 130, Stop Guarding]
type = ChangeState
trigger1 = command != "holdback"
trigger2 = !inguarddist
value = 140

; HITA_FALL (knocked up, falling)
[Statedef 5050]
type    = A
movetype= H
physics = N

[State 5050, 1] ;Change anim when done with transition
type = ChangeAnim
trigger1 = AnimTime = 0
trigger1 = Anim = 5035
trigger2 = Time = 0     ;If no transition anim
trigger2 = Anim != 5035
trigger2 = (Anim != [5051, 5059]) && (Anim != [5061, 5069])
trigger2 = Anim != 5090 ;Not if hit off ground anim
value = 5050

[State 5050, 2] ;Coming down anim
type = ChangeAnim
trigger1 = anim = [5050,5059]
trigger1 = Vel Y >= ifelse(anim = 5050, 1, -2)
trigger1 = SelfAnimExist(anim+10)
value = anim+10
persistent = 0

[State 5050, 3] ;Gravity
type = VelAdd
trigger1 = 1
y = GetHitVar(yaccel)

[State 5050, 6]
type = ChangeState
trigger1 = Vel Y > 3
;trigger1 = Pos Y >= ifelse((anim = [5051,5059]) || (anim = [5061,5069]), 0, 25)
trigger1 = Pos Y >= -4
value = 5200 ;comeback

; HIT_FALLRECOVER (still falling)
[Statedef 5200]
type    = A
movetype= H
physics = N

[State 5200, 1] ;Change anim if done with transition
type = ChangeAnim
trigger1 = Anim = 5035
trigger1 = AnimTime = 0
value = 5050

[State 5200, 2]
type = VelAdd
trigger1 = 1
y = GetHitVar(yaccel)

[State 5200, 3]
type = SelfState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 10
value = 5201

; HIT_FALLRECOVER (on the ground)
[Statedef 5201]
type    = A
movetype= H
physics = N
anim = 5999
velset = -1, -3

[State 5201, 1] ;Turn if not facing opponent
type = Turn
trigger1 = Time = 0
trigger1 = p2dist X < -5

[State 5201, 2]
type = Veladd
trigger1 = Time = 5
trigger1 = Time = 10
trigger1 = Time = 15
x = -1
y = -3.5

[State 5201, 3]
type = PosSet
trigger1 = Time = 0
y = 0

[State 5201, 4]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[State 5200, 3]
type = ChangeState
trigger1 = AnimTime = 0
value = 0

[State 5200, 3]
type = ChangeState
trigger1 = alive = 0
value = 5400

; HIT_LIEDEAD
[Statedef 5400]
type    = L
movetype= H
physics = N
sprpriority = -3

[State 5150, 1] ;Normal anim
type = ChangeAnim
triggerall = Time = 0
triggerall = SelfAnimExist(5140)
trigger1 = (anim != [5111,5119]) && (anim != [5171,5179])
trigger2 = !SelfAnimExist(5140 + (anim % 10))
value = 5400

[State 5150, 3] ;Hit up type anim
type = ChangeAnim
trigger1 = Time = 0
trigger1 = (anim = [5111,5119]) || (anim = [5171,5179])
trigger1 = SelfAnimExist(5140 + (anim % 10))
value = 5400 + (anim % 10)

[State 5150, 4] ;Match over anim
type = ChangeAnim
persistent = 0
;trigger1 = Time = 0
trigger1 = MatchOver = 1
trigger1 = Anim = [5140,5149]
trigger1 = SelfAnimExist(anim+10)
value = anim+10


[State 5150, 5] ;Switch to 5110 if liedead anim does not exist
type = ChangeAnim
trigger1 = Time = 0
trigger1 = Anim != [5140,5159]
trigger1 = Anim != [5110,5119]
value = 5400

[State 5150, 6] ;Friction
type = VelMul
trigger1 = 1
x = 0.85

[State 5150, 7] ;Friction
type = VelSet
trigger1 = Vel x < .05
persistent = 0
x = 0

[State 5150, 8]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[State 5200, 3]
type = ChangeState
trigger1 = time = 0
value = 5150

; HIT_LIEDEAD
[Statedef 5150]
type    = L
movetype= H
physics = N
sprpriority = -3
velset = 0,0

[State 5150, 1] ;Normal anim
type = ChangeAnim
triggerall = Time = 0
triggerall = SelfAnimExist(5140)
trigger1 = (anim != [5111,5119]) && (anim != [5171,5179])
trigger2 = !SelfAnimExist(5140 + (anim % 10))
value = 5400

[State 5150, 3] ;Hit up type anim
type = ChangeAnim
trigger1 = Time = 0
trigger1 = (anim = [5111,5119]) || (anim = [5171,5179])
trigger1 = SelfAnimExist(5140 + (anim % 10))
value = 5400 + (anim % 10)

[State 5150, 4] ;Match over anim
type = ChangeAnim
persistent = 0
;trigger1 = Time = 0
trigger1 = MatchOver = 1
trigger1 = Anim = [5140,5149]
trigger1 = SelfAnimExist(anim+10)
value = anim+10


[State 5150, 5] ;Switch to 5110 if liedead anim does not exist
type = ChangeAnim
trigger1 = Time = 0
trigger1 = Anim != [5140,5159]
trigger1 = Anim != [5110,5119]
value = 5400

[State 5150, 6] ;Friction
type = VelMul
trigger1 = 1
x = 0.85

[State 5150, 7] ;Friction
type = VelSet
trigger1 = Vel x < .05
persistent = 0
x = 0

[State 5150, 8]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1


; HITA_FALL (knocked up, falling)
[Statedef 5070]
type    = A
movetype= H
physics = N

[State 5050, 1] ;Change anim when done with transition
type = ChangeAnim
trigger1 = AnimTime = 0
trigger1 = Anim = 5035
trigger2 = Time = 0     ;If no transition anim
trigger2 = Anim != 5035
trigger2 = (Anim != [5051, 5059]) && (Anim != [5061, 5069])
trigger2 = Anim != 5090 ;Not if hit off ground anim
value = 5050

[State 5050, 2] ;Coming down anim
type = ChangeAnim
trigger1 = anim = [5050,5059]
trigger1 = Vel Y >= ifelse(anim = 5050, 1, -2)
trigger1 = SelfAnimExist(anim+10)
value = anim+10
persistent = 0

[State 5050, 3] ;Gravity
type = VelAdd
trigger1 = 1
y = GetHitVar(yaccel)

[State 5050, 6]
type = ChangeState
trigger1 = Vel Y > 3
;trigger1 = Pos Y >= ifelse((anim = [5051,5059]) || (anim = [5061,5069]), 0, 25)
trigger1 = Pos Y >= -4
value = 5200 ;comeback

; HIT_FALLRECOVER (on the ground)
[Statedef 5100]
type    = A
movetype= H
physics = N
anim = 5999
velset = -1, -3

[State 5200, 3]
type = ChangeState
trigger1 = alive = 0
value = 5150

[State 5201, 1] ;Turn if not facing opponent
type = Turn
trigger1 = Time = 0
trigger1 = p2dist X < -5

[State 5201, 2]
type = Veladd
trigger1 = Time = 5
trigger1 = Time = 10
trigger1 = Time = 15
x = -1
y = -3.5

[State 5201, 3]
type = PosSet
trigger1 = Time = 0
y = 0

[State 5201, 4]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[State 5200, 3]
type = ChangeState
trigger1 = AnimTime = 0
value = 0

; HITA_UP (initial going up)
[Statedef 5030]
type    = A
movetype= H
physics = N
ctrl = 0

[State 5150, 1]
type = Explod
triggerall = numExplod(9090) <= 0
trigger1 = Time = 0 && alive = 0 && teamside = 2
Anim = 9090
id = 9090
postype = left
pos = 0, -50
vel = 9.5
accel = -.15
sprpriority = -3
scale = 1.4,1.4
removetime = 67
ownpal = 1

[State 5150, 1]
type = Explod
triggerall = numExplod(9090) <= 0
trigger1 = Time = 0 && alive = 0 && teamside = 1
Anim = 9091
id = 9090
postype = Right
pos = 0, -50
vel = -9.5
accel = .15
sprpriority = -3
scale = 1.4,1.4
removetime = 67

[State 5150, 1]
type = bgpalfx 
trigger1 = Time = 0 && alive = 0
add = 255,255,255
Time = 70

[State 5030, 1]
type = VelAdd;Gravity
trigger1 = 1
y = GetHitVar(yaccel)

[State 5030, 2]
type = HitVelSet
trigger1 = Time = 0
x = 1
y = 1

[State 5030, 3]
type = ChangeState
triggerall = !HitFall
trigger1 = HitOver
trigger2 = Vel Y > 0    ;Hit ground
trigger2 = Pos Y >= 10  ;.
value = 5040 ;HITA_RECOV

[State 5030, 4]
type = ChangeState
triggerall = HitFall
trigger1 = HitOver
trigger2 = Vel Y > 0    ;Hit ground
trigger2 = Pos Y >= 10  ;.
value = 5050 ;HITA_FALL

[State 5030, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 5035 ;HITA_UP (transition)

; HIT_FALLRECOVER (on the ground)
[Statedef 5110]
type    = A
movetype= H
physics = N
anim = 5999
velset = -1, -3

[State 5201, 1] ;Turn if not facing opponent
type = Turn
trigger1 = Time = 0
trigger1 = p2dist X < -5

[State 5201, 2]
type = Veladd
trigger1 = Time = 5
trigger1 = Time = 10
trigger1 = Time = 15
x = -1
y = -3.5

[State 5201, 3]
type = PosSet
trigger1 = Time = 0
y = 0

[State 5201, 4]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[State 5200, 3]
type = ChangeState
trigger1 = AnimTime = 0
value = 0

; Initialize (at the start of the round)
[Statedef 5900]
type = S

[State 0, 0]
type = VarSet
trigger1 = Var(0) <= 0
trigger1 = alive = 1
v = 0
value = Life

[State 2000, 5]
type = Helper
triggerall = numHelper(2000) = 0
trigger1 = roundstate = 0
ID = 2000
name = "Sister"
pos = 0, 0
postype = Back
stateno = 2191
helpertype = normal
keyctrl = 0
ownpal = 1

[State 4000, 5]
type = Helper
triggerall = numHelper(4000) = 0
trigger1 = roundstate = 0
ID = 4000
name = "Avdol"
pos = 0, 0
postype = Front
stateno = 4191
helpertype = normal
keyctrl = 0
ownpal = 1

[State 5900, 1] ;Clear all int variables
type = VarRangeSet
trigger1 = roundsexisted = 0
value = 0

[State 5900, 2] ;Clear all float variables
type = VarRangeSet
trigger1 = roundsexisted = 0
fvalue = 0

[State 5900, 3] ;Intro for round 1
type = ChangeState
trigger1 = roundno = 1
value = 190
;---------------------------------------------------------------------------
; States that are always executed (use statedef -2)
;---------------------------------------------------------------------------

;The following was copied directly from Orochi_Herman's Shadow Dio.  Thanks!

; Super BG element
[Statedef 9006]
physics = N
velset = 0,0,0
anim = 1208
ctrl = 0

[State hah]
type = VarSet
trigger1 = Time = 0
fvar(1) = .05;2

[State hah]
type = VarSet
trigger1 = Time = 0
fvar(4) = .05;2

[State 1010, Super A]
type     = SuperPause
trigger1 = Time = 0
pos      = -10, -60
anim     = -1 ;S7010 ;102
time     = 32
movetime = 32
poweradd = -1000
darken   = 0

[State 2000, JoJo2]
type = Explod
trigger1 = Time = 0 ;&& root, var(37) = 1
anim = 9006
id = 70061
pos = 0,0
postype = left
sprpriority = -4
bindtime = -1
removetime = -1
scale = 0.83333333333333333333333333333333,1.0810810810810810810810810810811
ignorehitpause = 1
supermovetime = -1
ownpal = 1

[State 2000, JoJo2]
type = Explod
trigger1 = Time = 0 ;&& root, var(37) = 1
anim = 7007
id = 7007
pos = 0,0
postype = left
sprpriority = -3
bindtime = -1
scale = 0.83333333333333333333333333333333,1.0810810810810810810810810810811
removetime = 30
ignorehitpause = 1
supermovetime = -1
ownpal = 1

[State , EnvColor0]
type = EnvColor
trigger1 = time = [0,1]
trigger2 = time = [16,17]
value = 255,255,255
time = 1
;under = 1

[State that starts the inverted effect]
type           = PalFX
;triggerall     = root, var(37) = 1
trigger1       = 1 ;time = 0
;add            = 210,210,210
;add            = 255,255,255
add            = var(1),var(1),var(1)
;sinadd         = -250,-250,-250,80 ;120
time           = 1;5;0
ignorehitpause = 1
;superpausetime = 999999

[state haha]
type = varset
trigger1 = time = 0
trigger2 = time = 16
var(1) = 255

[state haha]
type = varadd
trigger1 = time % 2 = 0
;trigger2 = time = [16,31]
var(1) = -32 ;16

;[State that starts the inverted effect]
;type           = PalFX
;triggerall     = root, var(37) = 1
;trigger1       = Time = 15 
;add            = 250,250,250
;sinadd         = -250,-250,-250,80 ;120
;time           = 16;0
;ignorehitpause = 1
;superpausetime = 999999

[state haha]
type = displaytoclipboard
trigger1 = 1
text = "var(1) = %d"
params = var(1)

[state haha]
type = varset
trigger1 = time = 0
var(2) = 0

[state haha]
type = varadd
trigger1 = time = [4,24]
var(2) = 10 ;9

[State 2000, JoJo2 Super Portrait]
type = Explod
;trigger1 = root, var(37) = 1
trigger1 = (time = [4,31]) && fvar(1) <= 2
anim = 7000 ;+ (root, var(16))
id = 7000
pos = -20, ceil(224 * const(size.yscale)) ;+ ifelse((time = [4,24]), 12, 0)
postype = back
sprpriority = -1
;vel = 0, ifelse((time = [4,24]), 12, 0)
bindtime = 1
removetime = -1
scale = const(size.xscale) * (fvar(1)), const(size.yscale) * (fvar(4))
persistent = 0
ignorehitpause = 1
supermovetime = -1
removeongethit = 1
ownpal = 1

[State 3000, change!]
type = ModifyExplod
;trigger1 = root, var(37) = 1
trigger1 = Time = [4,31]
anim = 7000 ;+ (root, var(16))
id = 7000
;pos = (-20 + (var(11) * IfElse(random >= 500, -1, 1))),(ceil(240 * const(size.yscale)) + (var(11) * IfElse(random >= 500, -1, 1)))
pos = -20, floor(224 * const(size.yscale)) + var(2)
postype = back
sprpriority = -2
supermovetime = 40
;velocity = 0, ifelse((time = [4,24]), 12, 0)
random = 30,30
bindtime = 1
scale = const(size.xscale) * (fvar(1)), const(size.yscale) * (fvar(4))
removeongethit = 1
ownpal = 1

[State 2000, 4]
type = Explod
;trigger1 = root, var(37) = 0
trigger1 = (time = [1,31])
anim = 7001
id = 7000
pos = 0, 0
postype = back
sprpriority = -1
bindtime = 1
removetime = -1
scale = const(size.xscale), const(size.yscale)
persistent = 0
ignorehitpause = 1
supermovetime = -1
removeongethit = 1
ownpal = 1

[State haha]
type = VarAdd
trigger1 = fvar(1) <= 2;(2 * Const(size.xscale))
fvar(1) = .09 ;* Const(size.xscale)

[State haha]
type = VarAdd
trigger1 = fvar(4) <= 2;(2 * Const(size.yscale))
fvar(4) = .09 ;* Const(size.yscale)

[State hah]
type = RemoveExplod
trigger1 = Time >= 32
id = 7000

[State 1010, Effect]
type     = AssertSpecial
trigger1 = time = [0, 31]
flag     = nobardisplay
flag2    = nobg
flag3    = nofg
;pausemovetime = 40
ignorehitpause = 1


[State 1010, Effect]
type     = AssertSpecial
trigger1 = time = [0, 31]
flag     = globalnoshadow
flag2    = timerfreeze
;pausemovetime = 40
ignorehitpause = 1

[State heh]
type = RemoveExplod
trigger1 = Time >= 32 ;&& root, var(37) = 1
id = 70061

;[State heh]
;type = RemoveExplod
;trigger1 = Time >= 30 ;&& root, var(37) = 0
;id = 9000

[State leh]
type = DestroySelf
trigger1 = Time >= 32


[Statedef -2]

[State -2]
type = Helper
trigger1 =!numHelper(2000)
ID = 2000
name = "Sister"
pos = 20, 0
postype = Back
stateno = 2191
helpertype = normal
keyctrl = 0
ownpal = 1

[State -2]
type = Helper
trigger1 =!numHelper(4000) 
ID = 4000
name = "Avdol"
pos = 0, 0
postype = Front
stateno = 4191
helpertype = normal
keyctrl = 0
ownpal = 1

;---------------------------------------------------------------------------
; States that are executed when in self's state file (use statedef -3)
;---------------------------------------------------------------------------

;[Statedef -3]



;-------------------
;MEE Template Files
;   provided by
;  Kitsune Sniper
;       ***
; Thanks, Kitsune!
;-------------------
